/*
 * Decompiled with CFR 0.152.
 */
package Entity;

import Entity.Animation;
import Handlers.Options;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;

public abstract class GameObject {
    protected int tileSize;
    protected double xmap;
    protected double ymap;
    protected double x;
    protected double y;
    protected double dx;
    protected double dy;
    protected int width;
    protected int height;
    protected int cwidth;
    protected int cheight;
    protected int tweakx;
    protected int tweaky;
    protected int currRow;
    protected int currCol;
    protected double xdest;
    protected double ydest;
    protected double xtemp;
    protected double ytemp;
    protected boolean topLeft;
    protected boolean topRight;
    protected boolean bottomLeft;
    protected boolean bottomRight;
    protected Animation animation = new Animation();
    protected int currentAction;
    protected int previousAction;
    protected double rotation = -1.0;
    protected double angle = 90.0;
    protected boolean left;
    protected boolean right;
    protected boolean up;
    protected boolean down;
    protected double moveSpeed;
    protected double maxSpeed;
    protected double stopSpeed;

    public boolean intersects(GameObject o) {
        Rectangle r1 = this.getRectangle();
        Rectangle r2 = o.getRectangle();
        return r1.intersects(r2);
    }

    public Rectangle getRectangle() {
        return new Rectangle((int)this.x, (int)this.y, this.cwidth, this.cheight);
    }

    public void checkTileMapCollision() {
        this.xdest = this.x + this.dx;
        this.ydest = this.y + this.dy;
    }

    public void setTweakx(int i) {
        this.tweakx = i;
    }

    public void setTweaky(int i) {
        this.tweaky = i;
    }

    public int getx() {
        return (int)this.x;
    }

    public int gety() {
        return (int)this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getCWidth() {
        return this.cwidth;
    }

    public int getCHeight() {
        return this.cheight;
    }

    public void setPosition(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public void setVector(double dx, double dy) {
        this.dx = dx;
        this.dy = dy;
    }

    public void setLeft(boolean b) {
        this.left = b;
    }

    public void setRight(boolean b) {
        this.right = b;
    }

    public void setUp(boolean b) {
        this.up = b;
    }

    public void setDown(boolean b) {
        this.down = b;
    }

    public boolean notOnScreen() {
        return this.x + this.xmap + (double)this.width < 0.0 || this.x + this.xmap - (double)this.width > 800.0 || this.y + this.ymap + (double)this.height < 0.0 || this.y + this.ymap - (double)this.height > 400.0;
    }

    public void draw(Graphics2D g) {
        if (this.rotation != -1.0) {
            double rotationRequired = Math.toRadians(this.angle);
            double locationX = this.animation.getImage().getWidth() / 2;
            double locationY = this.animation.getImage().getHeight() / 2;
            AffineTransform tx = AffineTransform.getRotateInstance(rotationRequired, locationX, locationY);
            AffineTransformOp op = new AffineTransformOp(tx, 2);
            g.drawImage((Image)op.filter(this.animation.getImage(), null), (int)this.x + this.tweakx, (int)this.y + this.tweaky, null);
            this.angle += this.rotation;
            if (this.angle >= 360.0) {
                this.angle = 1.0;
            }
            if (this.angle <= 0.0) {
                this.angle = 359.0;
            }
        } else {
            g.drawImage((Image)this.animation.getImage(), (int)this.x + this.tweakx, (int)this.y + this.tweaky, null);
        }
        if (Options.getOption(3)) {
            g.setColor(Color.MAGENTA);
            g.drawRect((int)this.x, (int)this.y, this.cwidth, this.cheight);
        }
    }
}

